<?php
/**
* Auto detect language and currency
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate
*  @copyright 2017 idnovate
*  @license   See above
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

include_once(dirname(__FILE__).'/classes/AutoLanguageCurrencyConfiguration.php');
include_once(dirname(__FILE__).'/classes/geolocation.class.php');

class AutoLanguageCurrency extends Module
{
    private $_success;

    public function __construct()
    {
        $this->name = 'autolanguagecurrency';
        $this->tab = 'front_office_features';
        $this->version = '2.5.7';
        $this->author = 'idnovate';
        $this->module_key = '592b90796e28a9aad7f25bf8c5ffe45c';
        $this->addons_id_product = '7363';

        parent::__construct();

        $this->displayName = $this->l('Auto detect language and currency');
        $this->description = $this->l('Auto detect and change language and currency of visitors');
        $this->confirmUninstall = $this->l('Are you sure you want to delete this module?');
        $this->tabClassName = 'AdminAutoLanguageCurrencyConf';
        $this->secure_key = Tools::encrypt($this->name);
        //$this->ps_versions_compliancy = array('min' => '1.4', 'max' => _PS_VERSION_);

        /* Backward compatibility */
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
        }

        if (version_compare(_PS_VERSION_, '1.6', '>=')) {
            if (Configuration::get('PS_DISABLE_NON_NATIVE_MODULE')) {
                $this->warning = $this->l('You have to enable non PrestaShop modules at ADVANCED PARAMETERS - PERFORMANCE');
            }
        }
    }

    public function install()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            if (!parent::install() or
                !Configuration::updateValue('AUTOCURRLANG_ENABLED', '0') or
                !Configuration::updateValue('AUTOCURRENCY_ENABLED', '0') or
                !Configuration::updateValue('AUTOLANGUAGE_ENABLED', '0') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP', '0') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP_X', '') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP_Y', '50') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP_WIDTH', '500') or
                !Configuration::updateValue('AUTOCURRLANG_LOG', '0') or
                !Configuration::updateValue('AUTOCURRENCY_SELECTOR', '') or
                !Configuration::updateValue('AUTOLANGUAGE_SELECTOR', '') or
                !Configuration::updateValue('IGNORE_BOTS', '') or
                !Configuration::updateValue('AUTOCURRENCY_DEFAULT', Currency::getDefaultCurrency()->id) or
                !Configuration::updateValue('AUTOLANGUAGE_DEFAULT', Configuration::get('PS_LANG_DEFAULT')) or
                !$this->registerHook('header') or
                !$this->registerHook('footer')) {
                return false;
            }
            return true;
        } else {
            if (!parent::install() or
                !$this->initSQLConfiguration() or
                !Configuration::updateValue('AUTOCURRLANG_ENABLED', '0') or
                !Configuration::updateValue('AUTOCURRENCY_ENABLED', '0') or
                !Configuration::updateValue('AUTOLANGUAGE_ENABLED', '0') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP', '0') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP_X', '') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP_Y', '50') or
                !Configuration::updateValue('AUTOCURRLANG_POPUP_WIDTH', '500') or
                !Configuration::updateValue('AUTOCURRLANG_LOG', '0') or
                !Configuration::updateValue('AUTOCURRENCY_SELECTOR', '') or
                !Configuration::updateValue('AUTOLANGUAGE_SELECTOR', '') or
                !Configuration::updateValue('IGNORE_BOTS', '') or
                !Configuration::updateValue('AUTOCURRENCY_DEFAULT', Currency::getDefaultCurrency()->id) or
                !Configuration::updateValue('AUTOLANGUAGE_DEFAULT', Configuration::get('PS_LANG_DEFAULT')) or
                !$this->registerHook('displayHeader') or
                !$this->registerHook('displayTop') or
                !$this->registerHook('displayFooter')) {
                return false;
            }
            $this->addTab($this->displayName, $this->tabClassName, -1);
            return true;
        }
    }

    public function uninstall()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            if (!parent::uninstall() or
                !Configuration::deleteByName('AUTOCURRLANG_ENABLED') or
                !Configuration::deleteByName('AUTOCURRENCY_ENABLED') or
                !Configuration::deleteByName('AUTOLANGUAGE_ENABLED') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP_X') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP_Y') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP_WIDTH') or
                !Configuration::deleteByName('AUTOCURRLANG_LOG') or
                !Configuration::deleteByName('AUTOCURRENCY_SELECTOR') or
                !Configuration::deleteByName('AUTOLANGUAGE_SELECTOR') or
                !Configuration::deleteByName('IGNORE_BOTS') or
                !Configuration::deleteByName('AUTOCURRENCY_DEFAULT') or
                !Configuration::deleteByName('AUTOLANGUAGE_DEFAULT')) {
                return false;
            }
            return true;
        } else {
            if (!parent::uninstall() or
                !Configuration::deleteByName('AUTOCURRLANG_ENABLED') or
                !Configuration::deleteByName('AUTOCURRENCY_ENABLED') or
                !Configuration::deleteByName('AUTOLANGUAGE_ENABLED') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP_X') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP_Y') or
                !Configuration::deleteByName('AUTOCURRLANG_POPUP_WIDTH') or
                !Configuration::deleteByName('AUTOCURRLANG_LOG') or
                !Configuration::deleteByName('AUTOCURRENCY_SELECTOR') or
                !Configuration::deleteByName('AUTOLANGUAGE_SELECTOR') or
                !Configuration::deleteByName('IGNORE_BOTS') or
                !Configuration::deleteByName('AUTOCURRENCY_DEFAULT') or
                !Configuration::deleteByName('AUTOLANGUAGE_DEFAULT') or
                !$this->uninstallSQL()) {
                return false;
            }
            $this->removeTab($this->tabClassName);
            return true;
        }
    }

    public function hookTop($params)
    {
        return $this->hookDisplayTop($params);
    }

    public function hookDisplayTop($params)
    {
        return $this->hookDisplayFooter($params);
    }

    public function hookHeader($params)
    {
        return $this->hookDisplayHeader($params);
    }

    public function hookDisplayHeader($params)
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            return $this->run14();
        } else {
            return $this->run();
        }
    }

    public function hookFooter($params)
    {
        return $this->hookDisplayFooter($params);
    }

    public function hookDisplayFooter($params)
    {
        if (!Configuration::get('AUTOCURRLANG_ENABLED')) {
            return false;
        }

        $htmlCurr = '';
        $htmlLang = '';
        $jsIni = '<script type="text/javascript">';
        if ($this->context->cookie->autolocation_exception) {
            $autolanguagecurrency_exception = new AutoLanguageCurrencyConfiguration($this->context->cookie->autolocation_exception);
            if ($autolanguagecurrency_exception->hide_currency_selector != '') {
                $cssCurr = $autolanguagecurrency_exception->hide_currency_selector.' { visibility:hidden !important}';
                $htmlCurr = "var css = '".$cssCurr." { visibility:hidden !important}',head = document.head || document.getElementsByTagName('head')[0],style = document.createElement('style');style.type = 'text/css';if (style.styleSheet){style.styleSheet.cssText = css;} else {style.appendChild(document.createTextNode(css));}head.appendChild(style);";
            }
            if ($autolanguagecurrency_exception->hide_language_selector != '') {
                $cssLang = $autolanguagecurrency_exception->hide_language_selector.' { visibility:hidden !important}';
                $htmlLang = "var css = '".$cssLang." { visibility:hidden !important}',head = document.head || document.getElementsByTagName('head')[0],style = document.createElement('style');style.type = 'text/css';if (style.styleSheet){style.styleSheet.cssText = css;} else {style.appendChild(document.createTextNode(css));}head.appendChild(style);";
            }
        }
        $cssCurr = Configuration::get('AUTOCURRENCY_SELECTOR').' { visibility:hidden !important}';
        $cssLang = Configuration::get('AUTOLANGUAGE_SELECTOR').' { visibility:hidden !important}';
        if (Configuration::get('AUTOCURRENCY_SELECTOR')) {
            $htmlCurr = "var css = '".$cssCurr." { visibility:hidden !important}',head = document.head || document.getElementsByTagName('head')[0],style = document.createElement('style');style.type = 'text/css';if (style.styleSheet){style.styleSheet.cssText = css;} else {style.appendChild(document.createTextNode(css));}head.appendChild(style);";
        }
        if (Configuration::get('AUTOLANGUAGE_SELECTOR')) {
            $htmlLang = "var css = '".$cssLang." { visibility:hidden !important}',head = document.head || document.getElementsByTagName('head')[0],style = document.createElement('style');style.type = 'text/css';if (style.styleSheet){style.styleSheet.cssText = css;} else {style.appendChild(document.createTextNode(css));}head.appendChild(style);";
        }
        $jsEnd = '</script>';
        return $jsIni.$htmlLang.$htmlCurr.$jsEnd;
    }

    private function run()
    {
        if(!isset($_SESSION)) { 
            session_start();
        }

        if (!Configuration::get('AUTOCURRLANG_ENABLED')) {
            return false;
        }

        if ($this->ignoreBots()) {
            return false;
        }

        if ($this->context->cookie->catalog_mode && $this->context->cookie->catalog_mode == 1) {
            if (version_compare(_PS_VERSION_, '1.7', '>=')) {
                $is_catalog = array(
                    'is_catalog' => true,
                );
                $templateVars = array(
                    'configuration' => $is_catalog,
                );
                $this->context->smarty->assign($templateVars);
            } else {
                $this->context->smarty->assign(array(
                    'PS_CATALOG_MODE' => true
                ));
            }
        }

        /*
        if (!Configuration::get('AUTOCURRENCY_ENABLED') && !Configuration::get('AUTOLANGUAGE_ENABLED')) {
            return;
        }
        */

        $currencies_enabled = (int)count(Currency::getCurrencies());
        $languages_enabled = (int)count(Language::getLanguages(true));

        $headers = array();
        $headers[] = "HTTP/1.1 302 Moved Temporarily";
        if (Configuration::get('AUTOCURRLANG_ENABLED') == '1') {
            try {
                if (!isset($_COOKIE['alc_redirect'])) {
                    $_COOKIE['alc_redirect'] = false;
                }
                if (!isset($_SESSION['alc_redirect'])) {
                    $_SESSION['alc_redirect'] = false;
                }
                if((isset($_COOKIE['alc_redirect']) && $_COOKIE['alc_redirect'] == '1') || (isset($_SESSION['alc_redirect']) && $_SESSION['alc_redirect'] == '1')) {
                    $_COOKIE['alc_redirect'] == '1';
                    $_SESSION['alc_redirect'] == '1';
                    if((isset($_COOKIE['alc_redirect_url']) && $_COOKIE['alc_redirect_url'] != '')) {
                        Tools::redirect($_COOKIE['alc_redirect_url'], __PS_BASE_URI__, null, $headers);
                    }
                    if (isset($_SESSION['alc_redirect_url']) && $_SESSION['alc_redirect_url'] != '') {
                        Tools::redirect($_SESSION['alc_redirect_url'], __PS_BASE_URI__, null, $headers);
                    }
                } else {
                    $geolocation = $this->locate();
                    if ($geolocation->ip == null || $geolocation->countryCode == null) {
                        return false;
                    }
                    $exception = AutoLanguageCurrencyConfiguration::checkExceptions($geolocation->countryCode, $this->context->shop->id);
                    if ($exception) {
                        if ($exception['redirect_url'] && $exception['redirect_url'] != '') {
                            //Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'setCookie'));
                            //$this->context->cookie->autolocation_redirect = '1';
                            unset($this->context->cookie->autolocation);
                            if (strpos($exception['redirect_url'], 'http') === false) {
                                $this->setRedirectCookie(null, 'http://'.$exception['redirect_url']);
                                Tools::redirect('http://'.$exception['redirect_url'], __PS_BASE_URI__, null, $headers);
                            } else {
                                $this->setRedirectCookie(null, $exception['redirect_url']);
                                Tools::redirect($exception['redirect_url'], __PS_BASE_URI__, null, $headers);
                            }
                        }
                        if ($exception['redirect_shop'] && $exception['redirect_shop'] != '' && $exception['redirect_shop'] > 0) {
                            $shop = Shop::getShop($exception['redirect_shop']);
                            //$this->context->cookie->autolocation_redirect = '1';
                            $this->setRedirectCookie(null);
                            unset($this->context->cookie->autolocation);
                            if ($this->setRedirectCookie($shop['domain'])) {
                                //Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'setCookie'));
                                Tools::redirect((Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').$shop['domain'].$shop['uri'], __PS_BASE_URI__, null, $headers);
                            }
                        }
                        //$this->context->cookie->autolocation_redirect = '0';
                        //$this->setRedirectCookie('0');
                    }
                }
                if (!isset($this->context->cookie->autolocation) || $this->context->cookie->autolocation == '0' || !$this->context->cookie->autolocation) {
                    $geolocation = $this->locate();
                    if ($geolocation->ip == null || $geolocation->countryCode == null) {
                        return;
                    }
                    $this->context->cookie->autolocation = '1';

                    // For testing
                    //$geolocation->countryCode = 'CZ';
                    //$geolocation->currencyCode = 'CZK';

                    if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                        $log = fopen(dirname(__FILE__)."/log.html", 'a') or die("Can't open file\n");
                        fwrite($log, date("d/m/y H:i:s").'<br />');
                        fwrite($log, 'IP: '.$geolocation->ip.'<br />');
                        if (isset($this->context->cookie->email)) {
                            fwrite($log, 'Customer: '.$this->context->cookie->email.'<br />');
                        }
                        fwrite($log, 'Country: '.$geolocation->countryCode.' ('.htmlentities($geolocation->countryName, ENT_COMPAT, 'UTF-8').')'.'<br />');
                    }

                    if (Configuration::get('AUTOCURRENCY_ENABLED') == '1' && !$geolocation->currencyCode) {
                        $curr = Currency::getCurrency(Configuration::get('AUTOCURRENCY_DEFAULT'));
                        $geolocation->currencyCode = $curr['iso_code'];
                    }
                    if (Configuration::get('AUTOLANGUAGE_ENABLED') == '1' && !$geolocation->countryCode) {
                        $geolocation->countryCode = Language::getIsoById(Configuration::get('AUTOLANGUAGE_DEFAULT'));
                    }

                    //exceptions
                    $exception = AutoLanguageCurrencyConfiguration::checkExceptions($geolocation->countryCode, $this->context->shop->id);
                    if ($exception) {
                        if((isset($_COOKIE['alc_redirect']) && $_COOKIE['alc_redirect'] == '1') || (isset($_SESSION['alc_redirect']) && $_SESSION['alc_redirect'] == '1')) {
                            $_COOKIE['alc_redirect'] == '1';
                            $_SESSION['alc_redirect'] == '1';
                            if ($exception['redirect_url'] && $exception['redirect_url'] != '') {
                                //$this->context->cookie->autolocation_redirect = '1';
                                //Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'setCookie'));
                                if (strpos($exception['redirect_url'], 'http') === false) {
                                    $this->setRedirectCookie(null, 'http://'.$exception['redirect_url']);
                                    Tools::redirect('http://'.$exception['redirect_url'], __PS_BASE_URI__, null, $headers);
                                } else {
                                    $this->setRedirectCookie(null, $exception['redirect_url']);
                                    Tools::redirect($exception['redirect_url'], __PS_BASE_URI__, null, $headers);
                                }
                            }
                        } else {
                            if ($exception['redirect_url'] && $exception['redirect_url'] != '') {
                                //$this->context->cookie->autolocation_redirect = '1';
                                $this->setRedirectCookie(null);
                                //Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'setCookie'));
                                if (strpos($exception['redirect_url'], 'http') === false) {
                                    Tools::redirect('http://'.$exception['redirect_url'], __PS_BASE_URI__, null, $headers);
                                } else {
                                    Tools::redirect($exception['redirect_url'], __PS_BASE_URI__, null, $headers);
                                }
                            }
                            if ($exception['redirect_shop'] && $exception['redirect_shop'] != '' && $exception['redirect_shop'] > 0) {
                                $shop = Shop::getShop($exception['redirect_shop']);
                                //$this->context->cookie->autolocation_redirect = '1';
                                $this->setRedirectCookie(null);
                                if ($this->setRedirectCookie($shop['domain'])) {
                                    //Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'setCookie'));
                                    Tools::redirect((Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').$shop['domain'].$shop['uri'], __PS_BASE_URI__, null, $headers);
                                }
                            }
                        }
                        //$this->context->cookie->autolocation_redirect = '0';
                        //$this->setRedirectCookie('0');
                        $geolocation->countryCode = $exception['language'];
                        $geolocation->currencyCode = $exception['currency'];
                        $this->context->cookie->autolocation_exception = $exception['id'];
                        if ($exception['catalog_mode'] && $exception['catalog_mode'] == 1) {
                            $this->context->cookie->catalog_mode = 1;
                            if (version_compare(_PS_VERSION_, '1.7', '>=')) {
                                $is_catalog = array(
                                    'is_catalog' => true,
                                );
                                $templateVars = array(
                                    'configuration' => $is_catalog,
                                );
                                $this->context->smarty->assign($templateVars);
                            } else {
                                $this->context->smarty->assign(array(
                                    'PS_CATALOG_MODE' => true
                                ));
                            }
                        }
                    }

                    $arabic_langs = $this->getArabicLanguages();
                    if (in_array($geolocation->countryCode, $arabic_langs)) {
                        $geolocation->countryCode = 'AR';
                    }

                    $spanish_langs = $this->getSpanishLanguages();
                    if (in_array($geolocation->countryCode, $spanish_langs)) {
                        $geolocation->countryCode = 'ES';
                    }

                    $english_langs = $this->getEnglishLanguages();
                    if (in_array($geolocation->countryCode, $english_langs)) {
                        $geolocation->countryCode = 'EN';
                    }

                    $swiss_langs = $this->getSwitzerlandLanguages();
                    if (in_array($geolocation->countryCode, $swiss_langs)) {
                        $geolocation->countryCode = 'DE';
                    }

                    $german_langs = $this->getGermanLanguages();
                    if (in_array($geolocation->countryCode, $german_langs)) {
                        $geolocation->countryCode = 'DE';
                    }

                    $czech_langs = $this->getCzechRepublicLanguages();
                    if (in_array($geolocation->countryCode, $czech_langs)) {
                        $geolocation->countryCode = 'CS';
                    }

                    $israel_langs = $this->getIsraelLanguages();
                    if (in_array($geolocation->countryCode, $israel_langs)) {
                        $geolocation->countryCode = 'HE';
                    }

                    $geoCurrencyCode = trim(Tools::strtoupper($geolocation->currencyCode));

                    //Currency ISO codes mappings
                    //Argentina ARP
                    if ($geoCurrencyCode == 'ARP') {
                        $geoCurrencyCode = 'ARS';
                    }
                    //Argentina ARA
                    if ($geoCurrencyCode == 'ARA') {
                        $geoCurrencyCode = 'ARS';
                    }
                    //Mexico MXP
                    if ($geoCurrencyCode == 'MXP') {
                        $geoCurrencyCode = 'MXN';
                    }
                    //Brasil BRC
                    if ($geoCurrencyCode == 'BRC') {
                        $geoCurrencyCode = 'BRL';
                    }
                    //Uruguay UYP
                    if ($geoCurrencyCode == 'UYP') {
                        $geoCurrencyCode = 'UYU';
                    }
                    //Poland PLZ
                    if ($geoCurrencyCode == 'PLZ') {
                        $geoCurrencyCode = 'PLN';
                    }

                    if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                        fwrite($log, 'Country currency: '.$geoCurrencyCode.'<br />');
                    }

                    $default_currency = Configuration::get('AUTOCURRENCY_DEFAULT');
                    $default_language = Configuration::get('AUTOLANGUAGE_DEFAULT');

                    //Language to assign
                    $id_language_by_location = Language::getIdByIso($geolocation->countryCode);
                    if (isset($id_language_by_location)) {
                        if ($id_language_by_location == 0 || $id_language_by_location == '') {
                            $id_language_by_location = $default_language;
                        }
                    } else {
                        $id_language_by_location = $default_language;
                    }
                    $language_to_change = Language::getLanguage($id_language_by_location);

                    //Currency to assign
                    $id_currency_by_location = Currency::getIdByIsoCode($geoCurrencyCode, (int)$this->context->shop->id);
                    if (isset($id_currency_by_location)) {
                        if ($id_currency_by_location == 0 || $id_currency_by_location == '') {
                            $id_currency_by_location = $default_currency;
                        }
                    } else {
                        $id_currency_by_location = $default_currency;
                    }
                    $currency_to_change = Currency::getCurrencyInstance($id_currency_by_location);

                    $this->smarty->assign(array(
                        'currency'    => (!Configuration::get('AUTOCURRENCY_ENABLED')) ? 'none' : $geoCurrencyCode,
                        'language'    => (!Configuration::get('AUTOLANGUAGE_ENABLED')) ? 'none' : $geolocation->countryCode,
                        'language_to_change' => $language_to_change['name'],
                        'language_to_change_iso' => Tools::strtoupper($language_to_change['iso_code']),
                        'currency_to_change' => $currency_to_change->name,
                        'currency_to_change_iso' => Tools::strtoupper($currency_to_change->iso_code),
                        'id_lang'     => $id_language_by_location,
                        'id_currency' => $id_currency_by_location,
                        'rewrite' => Configuration::get('PS_REWRITING_SETTINGS'),
                        'ps_version' => _PS_VERSION_,
                        'ps_base_uri' => __PS_BASE_URI__,
                        'change_currency_ctrl' => $this->context->link->getModuleLink('autolanguagecurrency', 'ChangeCurrency'),
                        'change_language_ctrl' => $this->context->link->getModuleLink('autolanguagecurrency', 'ChangeLanguage'),
                        'ps_base_url' => $this->getShopDomain(true, true).__PS_BASE_URI__
                    ));

                    if (Configuration::get('AUTOCURRLANG_ENABLED') == '1') {
                        $redirect_tpl = '0';
                        $prev_iso_code = $this->context->language->iso_code;
                        if (Configuration::get('AUTOCURRENCY_ENABLED') == '1' && $id_currency_by_location != $this->context->cookie->id_currency) {
                            if (!isset($this->context->cookie->id_currency_by_location)) {
                                $this->context->cookie->id_currency = $id_currency_by_location;
                                $this->context->cookie->id_currency_by_location = $id_currency_by_location;
                                //Tools::setCurrency($this->context->cookie);
                                $_currency = new Currency((int)$id_currency_by_location);
                                if (Validate::isLoadedObject($_currency) && !$_currency->deleted) {
                                    $this->context->cookie->id_currency = (int)$_currency->id;
                                }
                                $currency = Currency::getCurrencyInstance((int)$id_currency_by_location);
                                if (is_object($currency) && $currency->id && !$currency->deleted && $currency->isAssociatedToShop()) {
                                    $this->context->cookie->id_currency = (int)$currency->id;
                                }
                                //Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'ChangeCurrency').'?id_currency='.$id_currency_by_location);
                                $redirect_tpl = '1';
                            }
                            if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                fwrite($log, 'Currency assigned: '.htmlentities($currency_to_change->name, ENT_COMPAT, 'UTF-8').'<br />');
                            }
                        } else {
                            $currency_cookie = Currency::getCurrency((int)$this->context->cookie->id_currency);
                            if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                fwrite($log, 'Currency assigned: '.htmlentities($currency_cookie['name'], ENT_COMPAT, 'UTF-8').'<br />');
                            }
                        }
                        if (Configuration::get('AUTOLANGUAGE_ENABLED') == '1' && $id_language_by_location != $this->context->cookie->id_lang) {
                            if (!isset($this->context->cookie->id_language_by_location)) {
                                $this->context->cookie->id_lang = $id_language_by_location;
                                $this->context->cookie->id_language_by_location = $id_language_by_location;
                                $language = new Language($id_language_by_location);
                                if (Validate::isLoadedObject($language) && (bool)$language->active) {
                                    $this->context->cookie->id_lang = (int)$language->id;
                                    $this->context->language = $language;
                                }
                                //Set country
                                $id_country = Country::getByIso($geolocation->countryCode);
                                $country = new Country((int)$id_country);
                                $this->context->country = $country;
                                //$return_language = Tools::file_get_contents($this->context->link->getModuleLink('autolanguagecurrency', 'ChangeLanguage').'?idlang='.$id_language_by_location);
                                $redirect_tpl = '1';
                            }
                            if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                fwrite($log, 'Language assigned: '.htmlentities($language_to_change['name'], ENT_COMPAT, 'UTF-8').'<br />');
                            }
                        } else {
                            $language_cookie = Language::getLanguage($this->context->cookie->id_lang);
                            if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                fwrite($log, 'Language assigned: '.htmlentities($language_cookie['name'], ENT_COMPAT, 'UTF-8').'<br />');
                            }
                        }

                        if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                            fwrite($log, '--------------------<br />');
                        }

                        if ($redirect_tpl == '1') {
                            $this->context->smarty->assign(array(
                                'lang_iso'    => $this->context->language->iso_code,
                                'id_lang'     => $id_language_by_location,
                                'id_currency' => $id_currency_by_location
                            ));
                            if (Configuration::get('PS_REWRITING_SETTINGS') == '1') {
                                $shop = Shop::getShop($this->context->shop->id);
                                //Tools::redirect($shop['domain'].$shop['uri']);
                                if ('index' == $this->context->controller->php_self) {
                                    Tools::redirect($this->getShopDomain(true, true).$shop['uri'].$this->context->language->iso_code.'/', __PS_BASE_URI__, null, $headers);
                                } else {
                                    Tools::redirect(str_replace('/'.$prev_iso_code.'/', '/'.$this->context->language->iso_code.'/', $this->getShopDomain(true, true).$_SERVER['REQUEST_URI']), __PS_BASE_URI__, null, $headers);
                                }
                            } else {
                                Tools::redirect($this->getShopDomain(true, true).$_SERVER['REQUEST_URI'], __PS_BASE_URI__, null, $headers);
                            }
                            //return $this->display(__FILE__, 'autolanguagecurrency.tpl');
                        } else {
                            return;
                        }
                    }
                }
                //$this->context->cookie->autolocation_redirect = '0';
                //$this->setRedirectCookie('0');
            } catch (Exception $e) {
                return false;
            }
        }
    }

    private function run14()
    {
        if (!Configuration::get('AUTOCURRLANG_ENABLED')) {
            return;
        }

        if (!Configuration::get('AUTOCURRENCY_ENABLED') && !Configuration::get('AUTOLANGUAGE_ENABLED')) {
            return;
        }

        $currencies_enabled = (int)count(Currency::getCurrencies());
        $languages_enabled = (int)count(Language::getLanguages(true));

        if ($currencies_enabled > 1 || $languages_enabled > 1) {
            if (Configuration::get('AUTOCURRLANG_ENABLED') == '1') {
                try {
                    if (!isset($this->context->cookie->autolocation)) {
                        $geolocation = $this->locate();

                        // For testing
                        //$geolocation->countryCode = 'CZ';
                        //$geolocation->currencyCode = 'CZK';

                        if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                            $log = fopen(dirname(__FILE__)."/log.html", 'a') or die("Can't open file\n");
                            fwrite($log, date("d/m/y H:i:s").'<br />');
                            fwrite($log, 'IP: '.$geolocation->ip.'<br />');
                            if (isset($this->context->cookie->email)) {
                                fwrite($log, 'Customer: '.$this->context->cookie->email.'<br />');
                            }
                            fwrite($log, 'Country: '.$geolocation->countryCode.' ('.htmlentities($geolocation->countryName, ENT_COMPAT, 'UTF-8').')'.'<br />');
                        }

                        if (Configuration::get('AUTOCURRENCY_ENABLED') == '1' && !$geolocation->currencyCode) {
                            $curr = Currency::getCurrency(Configuration::get('AUTOCURRENCY_DEFAULT'));
                            $geolocation->currencyCode = $curr['iso_code'];
                        }
                        if (Configuration::get('AUTOLANGUAGE_ENABLED') == '1' && !$geolocation->countryCode) {
                            $geolocation->countryCode = Language::getIsoById(Configuration::get('AUTOLANGUAGE_DEFAULT'));
                        }

                        $arabic_langs = $this->getArabicLanguages();
                        if (in_array($geolocation->countryCode, $arabic_langs)) {
                            $geolocation->countryCode = 'AR';
                        }

                        $spanish_langs = $this->getSpanishLanguages();
                        if (in_array($geolocation->countryCode, $spanish_langs)) {
                            $geolocation->countryCode = 'ES';
                        }

                        $english_langs = $this->getEnglishLanguages();
                        if (in_array($geolocation->countryCode, $english_langs)) {
                            $geolocation->countryCode = 'EN';
                        }

                        $swiss_langs = $this->getSwitzerlandLanguages();
                        if (in_array($geolocation->countryCode, $swiss_langs)) {
                            $geolocation->countryCode = 'DH';
                        }

                        $german_langs = $this->getGermanLanguages();
                        if (in_array($geolocation->countryCode, $german_langs)) {
                            $geolocation->countryCode = 'DE';
                        }

                        $czech_langs = $this->getCzechRepublicLanguages();
                        if (in_array($geolocation->countryCode, $czech_langs)) {
                            $geolocation->countryCode = 'CS';
                        }

                        $israel_langs = $this->getIsraelLanguages();
                        if (in_array($geolocation->countryCode, $israel_langs)) {
                            $geolocation->countryCode = 'HE';
                        }

                        $geoCurrencyCode = trim(Tools::strtoupper($geolocation->currencyCode));

                        //Currency ISO codes mappings
                        //Argentina ARP
                        if ($geoCurrencyCode == 'ARP') {
                            $geoCurrencyCode = 'ARS';
                        }
                        //Argentina ARA
                        if ($geoCurrencyCode == 'ARA') {
                            $geoCurrencyCode = 'ARS';
                        }
                        //Mexico MXP
                        if ($geoCurrencyCode == 'MXP') {
                            $geoCurrencyCode = 'MXN';
                        }
                        //Brasil BRC
                        if ($geoCurrencyCode == 'BRC') {
                            $geoCurrencyCode = 'BRL';
                        }
                        //Uruguay UYP
                        if ($geoCurrencyCode == 'UYP') {
                            $geoCurrencyCode = 'UYU';
                        }
                        //Poland PLZ
                        if ($geoCurrencyCode == 'PLZ') {
                            $geoCurrencyCode = 'PLN';
                        }

                        if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                            fwrite($log, 'Country currency: '.$geoCurrencyCode.'<br />');
                        }

                        $default_currency = Configuration::get('AUTOCURRENCY_DEFAULT');
                        $default_language = Configuration::get('AUTOLANGUAGE_DEFAULT');

                        if ($this->isActive($geolocation->countryCode) == '0') {
                            $id_language_by_location = $default_language;
                        } else {
                            $id_language_by_location = Language::getIdByIso($geolocation->countryCode);
                        }
                        if (isset($id_language_by_location)) {
                            if ($id_language_by_location == 0 || $id_language_by_location == '') {
                                $id_language_by_location = $default_language;
                            }
                        }
                        $language_to_change = Language::getLanguage($id_language_by_location);

                        $id_currency_by_location = Currency::getIdByIsoCode($geoCurrencyCode);

                        if (!isset($id_currency_by_location) || $id_currency_by_location == '' || $id_currency_by_location == '0') {
                            $id_currency_by_location = $default_currency;
                        }
                        $currency_to_change = Currency::getCurrency($id_currency_by_location);

                        $this->context->smarty->assign(array(
                            'autocurrency'    => $geoCurrencyCode,
                            'autolanguage'    => $geolocation->countryCode,
                            'language_to_change' => $language_to_change['name'],
                            'language_to_change_iso' => Tools::strtoupper($language_to_change['iso_code']),
                            'currency_to_change' => $currency_to_change['name'],
                            'currency_to_change_iso' => Tools::strtoupper($currency_to_change['iso_code']),
                            'id_lang'     => $id_language_by_location,
                            'id_currency' => $id_currency_by_location,
                            'rewrite' => Configuration::get('PS_REWRITING_SETTINGS'),
                            'ps_version' => _PS_VERSION_,
                            'ps_base_uri' => __PS_BASE_URI__,
                            'ps_base_url' => $this->getShopDomain(true, true).__PS_BASE_URI__
                        ));

                        if (!Configuration::get('AUTOCURRENCY_ENABLED')) {
                            $this->context->smarty->assign(array(
                                'autocurrency'    => 'none'
                            ));
                        }

                        if (!Configuration::get('AUTOLANGUAGE_ENABLED')) {
                            $this->context->smarty->assign(array(
                                'autolanguage'    => 'none'
                            ));
                        }

                        if (Configuration::get('AUTOCURRLANG_ENABLED') == '1') {
                            $redirect_tpl = '0';
                            if (Configuration::get('AUTOCURRENCY_ENABLED') == '1' && $id_currency_by_location != $this->context->cookie->id_currency) {
                                if (!isset($this->context->cookie->id_currency_by_location)) {
                                    $this->context->cookie->id_currency = $id_currency_by_location;
                                    $this->context->cookie->id_currency_by_location = $id_currency_by_location;
                                    Tools::setCurrency();
                                    $redirect_tpl = '1';
                                }

                                if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                    fwrite($log, 'Currency assigned: '.htmlentities($currency_to_change['name'], ENT_COMPAT, 'UTF-8').'<br />');
                                }
                            } else {
                                $currency_cookie = Currency::getCurrency((int)$this->context->cookie->id_currency);
                                if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                    fwrite($log, 'Currency assigned: '.htmlentities($currency_cookie['name'], ENT_COMPAT, 'UTF-8').'<br />');
                                }
                            }

                            if (Configuration::get('AUTOLANGUAGE_ENABLED') == '1' && $id_language_by_location != $this->context->cookie->id_lang) {
                                if (!isset($this->context->cookie->id_language_by_location)) {
                                    $this->context->cookie->id_lang = $id_language_by_location;
                                    $this->context->cookie->id_language_by_location = $id_language_by_location;
                                    Tools::switchLanguage();
                                    $redirect_tpl = '1';
                                }

                                if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                    fwrite($log, 'Language assigned: '.htmlentities($language_to_change['name'], ENT_COMPAT, 'UTF-8').'<br />');
                                }
                            } else {
                                $language_cookie = Language::getLanguage($this->context->cookie->id_lang);
                                if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                    fwrite($log, 'Language assigned: '.htmlentities($language_cookie['name'], ENT_COMPAT, 'UTF-8').'<br />');
                                }
                            }

                            if (Configuration::get('AUTOCURRLANG_LOG') == '1') {
                                fwrite($log, '--------------------<br />');
                            }

                            if ($redirect_tpl == '1') {
                                return $this->display(__FILE__, 'views/templates/hook/autolanguagecurrency14.tpl');
                            } else {
                                return;
                            }
                        }
                    }
                } catch (Exception $e) {
                    return;
                }
            }
        }
    }

    public function getContent()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            $this->_html = '';
        } else {
            $ok = '';
            if (((bool)Tools::isSubmit('submitAutoLanguageCurrencyModule')) == true) {
                if ($this->postProcess(true)) {
                    $ok = 'ok';
                } else {
                    $ok = 'nok';
                }
            }
            if (version_compare(_PS_VERSION_, '1.6', '<')) {
                return Tools::redirectAdmin('index.php?tab=' . $this->tabClassName . '&token=' . Tools::getAdminTokenLite($this->tabClassName).'&save='.$ok);
            } else {
                return Tools::redirectAdmin('index.php?controller=' . $this->tabClassName . '&token=' . Tools::getAdminTokenLite($this->tabClassName).'&save='.$ok);
            }
        }

        $this->_html .= '<h2>'.$this->l('Auto detect language and currency').'</h2>';
        if (Tools::isSubmit('submitForm') and Tools::getValue('currlang_enabled') != 0 and Tools::getValue('currlang_enabled') != 1) {
            $this->_html .= $this->displayError('Invalid selection');
        }
        if (Tools::isSubmit('submitForm') and Tools::getValue('curr_enabled') != 0 and Tools::getValue('curr_enabled') != 1) {
            $this->_html .= $this->displayError('Invalid selection');
        }
        if (Tools::isSubmit('submitForm') and Tools::getValue('lang_enabled') != 0 and Tools::getValue('lang_enabled') != 1) {
            $this->_html .= $this->displayError('Invalid selection');
        }
        if (Tools::isSubmit('submitForm') and Tools::getValue('popup') != 0 and Tools::getValue('popup') != 1) {
            $this->_html .= $this->displayError('Invalid selection');
        } elseif (Tools::isSubmit('submitForm')) {
            Configuration::updateValue('AUTOCURRLANG_ENABLED', Tools::getValue('currlang_enabled'));
            Configuration::updateValue('AUTOCURRENCY_ENABLED', Tools::getValue('curr_enabled'));
            Configuration::updateValue('AUTOLANGUAGE_ENABLED', Tools::getValue('lang_enabled'));
            Configuration::updateValue('AUTOCURRLANG_POPUP', Tools::getValue('popup'));
            Configuration::updateValue('AUTOCURRLANG_POPUP_X', Tools::getValue('popup_x'));
            Configuration::updateValue('AUTOCURRLANG_POPUP_Y', Tools::getValue('popup_y'));
            Configuration::updateValue('AUTOCURRLANG_POPUP_WIDTH', Tools::getValue('popup_width'));
            Configuration::updateValue('AUTOCURRLANG_LOG', Tools::getValue('log'));
            Configuration::updateValue('AUTOCURRENCY_SELECTOR', Tools::getValue('hide_currency_selector'));
            Configuration::updateValue('AUTOLANGUAGE_SELECTOR', Tools::getValue('hide_language_selector'));
            Configuration::updateValue('IGNORE_BOTS', Tools::getValue('ignore_bots'));
            Configuration::updateValue('AUTOCURRENCY_DEFAULT', Tools::getValue('curr_default'));
            Configuration::updateValue('AUTOLANGUAGE_DEFAULT', Tools::getValue('lang_default'));
            $this->_html .= $this->displayConfirmation($this->l('Settings updated successfully'));
        }

        $currencies = Currency::getCurrencies();
        $currencies_html = '';
        $default_currency = Currency::getDefaultCurrency()->name;
        foreach ($currencies as $currency) {
            if (Configuration::get('AUTOCURRENCY_DEFAULT') == $currency['id_currency']) {
                $default_currency = $currency['name'];
            }
            if (Configuration::get('AUTOCURRENCY_DEFAULT') != $currency['id_currency']) {
                $currencies_html .= '<option value='.$currency['id_currency'].'>'.$currency['name'].'</option>';
            }
        }

        $languages = Language::getLanguages(true);
        $languages_html = '';
        $default_language = new Language((int)(Configuration::get('PS_LANG_DEFAULT')));
        $default_language = $default_language->name;
        foreach ($languages as $language) {
            if (Configuration::get('AUTOLANGUAGE_DEFAULT') == $language['id_lang']) {
                $default_language = $language['name'];
            }
            if (Configuration::get('AUTOLANGUAGE_DEFAULT') != $language['id_lang']) {
                $languages_html .= '<option value='.$language['id_lang'].'>'.$language['name'].'</option>';
            }
        }

        $this->_html .= '
        <img src="'.$this->_path.'logo.png" style="float:left; margin-right:15px;" />
        <b>'.$this->l('This module allows to auto detect and change the language and currency depending the location of the visitor').'</b><br />
        '.$this->l('idnovate.com').'<br /><br /><br />';
        $this->_html .= '
        <form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
        <fieldset>
        <legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('General settings').'</legend>
            <label>'.$this->l('Enabled').'</label>
            <div class="margin-form">
                <input type="radio" name="currlang_enabled" id="on" value="1" '.(Configuration::get('AUTOCURRLANG_ENABLED') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                <input type="radio" name="currlang_enabled" id="off" value="0" '.(!Configuration::get('AUTOCURRLANG_ENABLED') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                <p class="clear">'.$this->l('Enable this functionality.').'</p>
            </div>
            <!-- <label>'.$this->l('Show popup window').'</label>
            <div class="margin-form">
                <input type="radio" name="popup" id="on" value="1" '.(Configuration::get('AUTOCURRLANG_POPUP') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                <input type="radio" name="popup" id="off" value="0" '.(!Configuration::get('AUTOCURRLANG_POPUP') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                <label class="t" for="popup_x">'.$this->l('Position X').'</label>
                <input type="text" name="popup_x" value="'.Configuration::get('AUTOCURRLANG_POPUP_X').'" maxlength="4" style="width: 30px;" />
                <label class="t" for="popup_y">'.$this->l('Position Y').'</label>
                <input type="text" name="popup_y" value="'.htmlentities(Tools::getValue('popup_y', Configuration::get('AUTOCURRLANG_POPUP_Y')), ENT_COMPAT, 'UTF-8').'" maxlength="4" style="width: 30px;" />
                <label class="t" for="popup_width">'.$this->l('Width').'</label>
                <input type="text" name="popup_width" value="'.htmlentities(Tools::getValue('popup_width', Configuration::get('AUTOCURRLANG_POPUP_WIDTH')), ENT_COMPAT, 'UTF-8').'" maxlength="4" style="width: 30px;" />
                 '.$this->l('(Left fields blank to center at screen)').'
                <p class="clear">'.$this->l('Show a popup window to inform to visitors.').'</p>
            </div> -->
            <label>'.$this->l('Activate log').'</label>
            <div class="margin-form">
                <input type="radio" name="log" id="on" value="1" '.(Configuration::get('AUTOCURRLANG_LOG') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                <input type="radio" name="log" id="off" value="0" '.(!Configuration::get('AUTOCURRLANG_LOG') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                <p class="clear">'.$this->l('Activate log').'&nbsp;<a href="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/autolanguagecurrency/log.html" target="_blank"> '.$this->l('View').' <img src="'.$this->_path.'views/img/open.png" alt="'.$this->l('View').'" title="'.$this->l('View').'" style="vertical-align:middle;" /></a></p>
            </div>
        </fieldset>
        <div class="clear" style="height: 10px;"></div>
        <fieldset>
        <legend><img src="'.$this->_path.'views/img/currency.png" alt="" title="" />'.$this->l('Currency settings').'</legend>
            <label>'.$this->l('Enable auto detect currency').'</label>
            <div class="margin-form">
                <input type="radio" name="curr_enabled" id="on" value="1" '.(Configuration::get('AUTOCURRENCY_ENABLED') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                <input type="radio" name="curr_enabled" id="off" value="0" '.(!Configuration::get('AUTOCURRENCY_ENABLED') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                <p class="clear">'.$this->l('Enable auto detect and change currency.').'</p>
            </div>
            <label>'.$this->l('Default currency').'</label>
            <div class="margin-form">
                <select name="curr_default">
                    <option value="'.(Configuration::get('AUTOCURRENCY_DEFAULT') ? Configuration::get('AUTOCURRENCY_DEFAULT') : '').'">'.$default_currency.'</option>
                    '.$currencies_html.'
                </select>
                <p class="clear">'.$this->l('Default currency to change if the currency of the visitor is not installed.').'</p>
            </div>
        </fieldset>
        <div class="clear" style="height: 10px;"></div>
        <fieldset>
        <legend><img src="'.$this->_path.'views/img/language.png" alt="" title="" />'.$this->l('Language settings').'</legend>
            <label>'.$this->l('Enable auto detect language').'</label>
            <div class="margin-form">
                <input type="radio" name="lang_enabled" id="on" value="1" '.(Configuration::get('AUTOLANGUAGE_ENABLED') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                <input type="radio" name="lang_enabled" id="off" value="0" '.(!Configuration::get('AUTOLANGUAGE_ENABLED') ? 'checked="checked" ' : '').'/>
                <label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                <p class="clear">'.$this->l('Enable auto detect and change language.').'</p>
            </div>
            <label>'.$this->l('Default language').'</label>
            <div class="margin-form">
                <select name="lang_default">
                    <option value="'.(Configuration::get('AUTOLANGUAGE_DEFAULT') ? Configuration::get('AUTOLANGUAGE_DEFAULT') : '').'">'.$default_language.'</option>
                    '.$languages_html.'
                </select>
                <p class="clear">'.$this->l('Default language to change if the language of the visitor is not installed.').'</p>
            </div>
            <center><input type="submit" name="submitForm" value="'.$this->l('Save').'" class="button" /></center>
        </fieldset>
        </form>';
        return $this->_html;
    }

    public function postProcess($general_config = false)
    {
        if ($general_config) {
            $errors = array();
            if (count($errors) > 0) {
                return 'nok';
            } else {
                $form_values = $this->getGeneralConfigFormValues();
                foreach (array_keys($form_values) as $key) {
                    Configuration::updateValue($key, Tools::getValue($key));
                }
            }
            return 'ok';
        }
    }

    public static function getGeneralConfigFormValues()
    {
        return array(
                'AUTOCURRLANG_ENABLED' => Configuration::get('AUTOCURRLANG_ENABLED'),
                'AUTOCURRENCY_ENABLED' => Configuration::get('AUTOCURRENCY_ENABLED'),
                'AUTOLANGUAGE_ENABLED' => Configuration::get('AUTOLANGUAGE_ENABLED'),
                'AUTOCURRLANG_POPUP' => Configuration::get('AUTOCURRLANG_POPUP'),
                'AUTOCURRLANG_POPUP_X' => Configuration::get('AUTOCURRLANG_POPUP_X'),
                'AUTOCURRLANG_POPUP_Y' => Configuration::get('AUTOCURRLANG_POPUP_Y'),
                'AUTOCURRLANG_POPUP_WIDTH' => Configuration::get('AUTOCURRLANG_POPUP_WIDTH'),
                'AUTOCURRLANG_LOG' => Configuration::get('AUTOCURRLANG_LOG'),
                'AUTOLANGUAGE_SELECTOR' => Configuration::get('AUTOLANGUAGE_SELECTOR'),
                'AUTOCURRENCY_SELECTOR' => Configuration::get('AUTOCURRENCY_SELECTOR'),
                'IGNORE_BOTS' => Configuration::get('IGNORE_BOTS'),
                'AUTOCURRENCY_DEFAULT' => Configuration::get('AUTOCURRENCY_DEFAULT'),
                'AUTOLANGUAGE_DEFAULT' => Configuration::get('AUTOLANGUAGE_DEFAULT'),
            );
    }

    public function locate()
    {
          /*"Geolocation results for {$geolocation->ip}: <br />\n".
            "City: {$geolocation->city} <br />\n".
            "Region: {$geolocation->region} <br />\n".
            "Area Code: {$geolocation->areaCode} <br />\n".
            "DMA Code: {$geolocation->dmaCode} <br />\n".
            "Country Name: {$geolocation->countryName} <br />\n".
            "Country Code: {$geolocation->countryCode} <br />\n".
            "Longitude: {$geolocation->longitude} <br />\n".
            "Latitude: {$geolocation->latitude} <br />\n".
            "Currency Code: {$geolocation->currencyCode} <br />\n".
            "Currency Symbol: {$geolocation->currencySymbol} <br />\n".
            "Default Currency Symbol: {$geolocation->currency} <br />\n".
            "Exchange Rate: {$geolocation->currencyConverter} <br />\n"*/

        /*"Geolocation with CloudFlare: <br />\n".
        "IP: $_SERVER["HTTP_CF_CONNECTING_IP"]"*/

        $ip = null;
        if (isset($_SERVER["REMOTE_ADDR"])) {
            $ip = $_SERVER["REMOTE_ADDR"];
        }
        if (isset($_SERVER["HTTP_X_REAL_IP"])) {
            $ip = $_SERVER["HTTP_X_REAL_IP"];
        }
        if (isset($_SERVER["HTTP_X_REMOTE_IP"])) {
            $ip = $_SERVER["HTTP_X_REMOTE_IP"];
        }
        if (isset($_SERVER["HTTP_REMOTE_IP"])) {
            $ip = $_SERVER["HTTP_REMOTE_IP"];
        }
        if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        }
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
        }
        
        $ip = explode(',', $ip);
        $geolocation = new Geolocation();
        $geolocation->locate(trim($ip[0]));

        return $geolocation;
    }

    private function setCurrencyByLocation($currency_location)
    {
        $default_currency = Configuration::get('AUTOCURRENCY_DEFAULT');

        if (_PS_VERSION_ < '1.5') {
            $id_currency_by_location = Currency::getIdByIsoCode($currency_location);
        } else {
            $id_currency_by_location = Currency::getIdByIsoCode($currency_location, (int)$this->context->shop->id);
        }

        if (isset($id_currency_by_location)) {
            if ($id_currency_by_location == 0 || $id_currency_by_location == '') {
                $id_currency_by_location = $default_currency;
            }
        }

        if ($this->context->cookie->id_currency != $id_currency_by_location && !isset($this->context->cookie->id_currency_by_location)) {
            if (_PS_VERSION_ < '1.5') {
                Tools::setCurrency();
            } else {
                Tools::setCurrency($this->context->cookie);
            }
        }
    }

    private function setLanguageByLocation($language_location)
    {
        $default_language = Configuration::get('AUTOLANGUAGE_DEFAULT');
        $id_language_by_location = Language::getIdByIso($language_location);

        if (isset($id_language_by_location)) {
            if ($id_language_by_location == 0 || $id_language_by_location == '') {
                $id_language_by_location = $default_language;
            }
        }

        if ($this->context->cookie->id_lang != $id_language_by_location && !isset($this->context->cookie->id_language_by_location)) {
            Tools::switchLanguage();
        }
    }

    private function checkCookies()
    {
        setcookie("idnovate", 1);
        if (isset($_COOKIE["idnovate"])) {
            return true;
        } else {
            return false;
        }
    }

    public function setRedirectCookie($domain = null, $url = '')
    {
        if ($domain == null) {
            $domain = $this->getDomain();
        }
        $_SESSION['alc_redirect'] = '1';
        $_SESSION['alc_redirect_url'] = $url;
        if (PHP_VERSION_ID <= 50200) { /* PHP version > 5.2.0 */
            setcookie('alc_redirect_url', $url, 0, '/', $domain, false);
            return setcookie('alc_redirect', true, 0, '/', $domain, false);
        } else {
            setcookie('alc_redirect_url', $url, 0, '/', $domain, false, true);
            return setcookie('alc_redirect', true, 0, '/', $domain, false, true);
        }
    }

    protected function getDomain($shared_urls = null)
    {
        $r = '!(?:(\w+)://)?(?:(\w+)\:(\w+)@)?([^/:]+)?(?:\:(\d*))?([^#?]+)?(?:\?([^#]+))?(?:#(.+$))?!i';

        if (!preg_match($r, Tools::getHttpHost(false, false), $out) || !isset($out[4])) {
            return false;
        }

        if (preg_match('/^(((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]{1}[0-9]|[1-9]).)'.
                       '{1}((25[0-5]|2[0-4][0-9]|[1]{1}[0-9]{2}|[1-9]{1}[0-9]|[0-9]).)'.
                       '{2}((25[0-5]|2[0-4][0-9]|[1]{1}[0-9]{2}|[1-9]{1}[0-9]|[0-9]){1}))$/', $out[4])) {
            return false;
        }
        if (!strstr(Tools::getHttpHost(false, false), '.')) {
            return false;
        }

        $domain = false;
        if ($shared_urls !== null) {
            foreach ($shared_urls as $shared_url) {
                if ($shared_url != $out[4]) {
                    continue;
                }
                if (preg_match('/^(?:.*\.)?([^.]*(?:.{2,4})?\..{2,3})$/Ui', $shared_url, $res)) {
                    $domain = '.'.$res[1];
                    break;
                }
            }
        }
        if (!$domain) {
            $domain = $out[4];
        }
        return $domain;
    }

    private function isActive($iso_code)
    {
        return Db::getInstance()->getValue('SELECT `active` FROM `'._DB_PREFIX_.'lang` WHERE `iso_code` = \''.pSQL(Tools::strtolower($iso_code)).'\'');
    }

    protected function initSQLConfiguration()
    {
        Db::getInstance()->Execute('
        CREATE TABLE IF NOT EXISTS `'.pSQL(_DB_PREFIX_.$this->name).'_configuration` (
            `id_autolanguagecurrency_configuration` int(10) unsigned NOT NULL auto_increment,
            `countries` VARCHAR(1000) NULL,
            `zones` VARCHAR(150) NULL,
            `language` int(4) NULL,
            `currency` int(4) NULL,
            `hide_language_selector` VARCHAR(150) NULL,
            `hide_currency_selector` VARCHAR(150) NULL,
            `catalog_mode` tinyint(1) unsigned NULL DEFAULT "0",
            `redirect_url` VARCHAR(150) NULL,
            `redirect_shop` int(4) NULL,
            `position` INT(5) NULL DEFAULT "0",
            `active` tinyint(1) unsigned NOT NULL DEFAULT "0",
            `id_shop` tinyint(1) unsigned NOT NULL DEFAULT "0",
            `date_add` DATETIME,
            `date_upd` DATETIME,
        PRIMARY KEY (`id_autolanguagecurrency_configuration`),
        KEY `id_autolanguagecurrency_configuration` (`id_autolanguagecurrency_configuration`)
        ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;');

        return true;
    }

    protected function uninstallSQL()
    {
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'.pSQL(_DB_PREFIX_.$this->name).'_configuration`');
        return true;
    }

    private function addTab($tabName, $tabClass, $idTabParent)
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            $langs = Language::getlanguages(false);
            $tabNames = array();
            foreach ($langs as $l) {
                $tabNames[$l['id_lang']] = $tabName;
            }
            $tab = new Tab();
            $tab->module = $this->name;
            $tab->name = $tabNames;
            $tab->class_name = $tabClass;
            $tab->id_parent = $idTabParent;

            if (!$tab->save()) {
                return false;
            }
        } else {
            $tab = new Tab();
            $tab->class_name = $tabClass;
            $tab->id_parent = $idTabParent;
            $tab->module = $this->name;
            $languages = Language::getLanguages();
            foreach ($languages as $language) {
                $tab->name[$language['id_lang']] = $this->l($tabClass);
            }
            $tab->add();
        }
        return true;
    }

    private function removeTab($tabClass)
    {
        $idTab = Tab::getIdFromClassName($tabClass);

        if ($idTab) {
            $tab = new Tab($idTab);
            $tab->delete();
            return true;
        }

        return false;
    }

    private function getShopDomain($http = false, $entities = false)
    {
        if (method_exists('Tools', 'getShopDomainSsl')) {
            return Tools::getShopDomainSsl($http, $entities);
        } else {
            if (!($domain = Configuration::get('PS_SHOP_DOMAIN_SSL'))) {
                $domain = self::getHttpHost();
            }
            if ($entities) {
                $domain = htmlspecialchars($domain, ENT_COMPAT, 'UTF-8');
            }
            if ($http) {
                $domain = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').$domain;
            }
            return $domain;
        }
    }

    private function ignoreBots()
    {
        if (Configuration::get('IGNORE_BOTS') == 0) {
            return false;
        } else if (strpos($_SERVER['REQUEST_URI'], 'gmc_currency')) {
            return true;
        } else {
            if (isset($_SERVER['HTTP_USER_AGENT'])) {
                $result = preg_filter($this->getBotStrings(), array_fill(1, count($this->getBotStrings()), '$0'), array(trim($_SERVER['HTTP_USER_AGENT'])));
                return (true == is_array($result) && 0 < count($result)) ? true : false;
            } else {
                return true;
            }
        }
        return false;
    }

    private function isModuleActive($name_module, $function_exist = false)
    {
        if (version_compare(_PS_VERSION_, '1.7.2', '>=')) {
            return false;
        }
        if (Module::isInstalled($name_module)) {
            $module = Module::getInstanceByName($name_module);
            if ((Validate::isLoadedObject($module) && $module->active) 
                || (Validate::isLoadedObject($module) && $name_module == 'prettyurls')
                || (Validate::isLoadedObject($module) && $name_module == 'purls')
                || (Validate::isLoadedObject($module) && $name_module == 'fsadvancedurl')
            ) {
                if ($function_exist) {
                    if (method_exists($module, $function_exist)) {
                        return $module;
                    } else {
                        return false;
                    }
                }
                return $module;
            }
        }
        return false;
    }

    private function getBotStrings()
    {
        return array (
             'googlebot'        => '/Googlebot/',
             'googlebot alt'    => '/googlebot/',
             'google page s'    => '/Google Page Speed Insights/',
             'google dtt'       => '/Google-Structured-Data-Testing-Tool/',
             'robot'            => '/Robot/',
             'crawl'            => '/Crawl/',
             'spider'           => '/Spider/',
             'msnbot'           => '/MSNBot/',
             'slurp'            => '/Inktomi/',
             'yahoo'            => '/Yahoo/',
             'askjeeves'        => '/AskJeeves/',
             'fastcrawler'      => '/FastCrawler/',
             'infoseek'         => '/InfoSeek/',
             'lycos'            => '/Lycos/',
             'yandex'           => '/YandexBot/',
             'geohasher'        => '/GeoHasher/',
             'gigablast'        => '/Gigabot/',
             'bingbot'          => '/bingbot/',
             'baidu'            => '/Baiduspider/',
             'spinn3r'          => '/Spinn3r/',
             'mj12bot'          => '/MJ12bot/',
             'Rambler'          => '/Rambler/',
             'Yahoo'            => '/Yahoo/',
             'AbachoBOT'        => '/AbachoBOT/',
             'accoona'          => '/Accoona/',
             'AcoiRobot'        => '/AcoiRobot/',
             'ASPSeek'          => '/ASPSeek/',
             'CrocCrawler'      => '/CrocCrawler/',
             'Dumbot'           => '/Dumbot/',
             'FAST-WebCrawler'  => '/FAST-WebCrawler/',
             'GeonaBot'         => '/GeonaBot/',
             'Gigabot'          => '/Gigabot/',
             'Lycos spider'     => '/Lycos/',
             'MSRBOT'           => '/MSRBOT/',
             'Altavista bot'    => '/Scooter/',
             'AltaVista robot'  => '/Altavista/',
             'ID-Search Bot'    => '/IDBot/',
             'eStyle Bot'       => '/eStyle/',
             'Scrubby robot'    => '/Scrubby/',
             'Facebook'         => '/facebookexternalhit/',
             'Facebook val'     => '/validator/',
             'AhrefsBot'        => '/AhrefsBot/',
             'Pingdom'          => '/Pingdom/',
             'Pingdom alt'      => '/pingdom/',
             'monitoring'       => '/Monitoring/',
             'checker'          => '/Checker/',
             'monitoring alt'   => '/monitoring/',
             'checker alt'      => '/checker/',
             'GIGRIB'           => '/gigrib/',
             'GIGRIB alt'       => '/GIGRIB/',
             'addthis'          => '/addthis/',
             'Facebot'          => '/Facebot/',
             'facebookexternalhit' => '/facebookexternalhit/'
        );
    }

    private function getArabicLanguages()
    {
        $array = array();
        $arabic_langs = 'DZ,BH,TD,KM,DJ,EG,ER,IQ,JO,KW,LB,LY,MR,MA,OM,QA,SA,SD,SY,TN,AE,YE';
        $array = explode(',', $arabic_langs);

        return $array;
    }

    private function getSpanishLanguages()
    {
        $array = array();
        $spanish_langs = 'MX,CO,ES,AR,VE,PE,CL,EC,GT,CU,DO,HN,BO,SV,NI,PY,CR,UY,PA,GQ';
        $array = explode(',', $spanish_langs);

        return $array;
    }

    private function getEnglishLanguages()
    {
        $array = array();
        $english_langs = 'US,EN,GB,AU,CA,IE,NZ,SG';
        $array = explode(',', $english_langs);

        return $array;
    }

    private function getSwitzerlandLanguages()
    {
        $array = array();
        $swiss_langs = 'CH';
        $array = explode(',', $swiss_langs);

        return $array;
    }

    private function getGermanLanguages()
    {
        $array = array();
        $german_langs = 'AT,LI';
        $array = explode(',', $german_langs);

        return $array;
    }

    private function getCzechRepublicLanguages()
    {
        $array = array();
        $czech_langs = 'CS,CZ';
        $array = explode(',', $czech_langs);

        return $array;
    }

    private function getIsraelLanguages()
    {
        $array = array();
        $israel_langs = 'IL,HE';
        $array = explode(',', $israel_langs);

        return $array;
    }
}
